import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './SharedMailboxClient.json';

export class SharedMailboxClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/shared_mailboxes/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async allUids( __fetchOptions = {}) {
        let __path = this.base + '/_alluids';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byEmail(email,  __fetchOptions = {}) {
        let __path = this.base + '/byEmail/{email}';
        __path = __path.replace('{email}', encodeURIComponent(email));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byName(login,  __fetchOptions = {}) {
        let __path = this.base + '/byName/{login}';
        __path = __path.replace('{login}', encodeURIComponent(login));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getLight(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/light';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getVCard(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/vcard';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
