
import { SharedMailbox } from "./SharedMailbox"; 
import { 
    TaskRef
} from "@bluemind/core.task.api";
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { 
    VCard
} from "@bluemind/addressbook.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ISharedMailbox {
    /**
     * Retrieve all existing {@link SharedMailbox} uids
     * @returns a list of all existing {@link SharedMailbox} uids
     */
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Fetches a {@link SharedMailbox} by its email
     * @param email the shared mailbox's email
     * @returns the shared mailbox item value, or null if the shared mailbox does not exist
     */
    byEmail(email: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SharedMailbox>>;
    /**
     * Fetches a {@link SharedMailbox} by its name
     * @param login the shared mailbox's login/name
     * @returns the shared mailbox item value, or null if the shared mailbox does not exist
     */
    byName(login: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SharedMailbox>>;
    /**
     * Deletes a {@link SharedMailbox}. Also deletes all shared mailbox related objects and
     * the shared mailbox's mailbox
     * @param uid the shared mailbox's unique id
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Fetches a {@link SharedMailbox} by its unique id
     * @param uid the shared mailbox's unique id
     * @returns the shared mailbox item value, or null if the shared mailbox does not exist
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SharedMailbox>>;
    /**
     * Fetches a {@link SharedMailbox} by its unique id, without vcard or mailbox
     */
    getLight(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SharedMailbox>>;
    /**
     * Retrieves a {@link SharedMailbox}'s contact informations
     * ({@link net.bluemind.addressbook.api.VCard})
     * @param uid shared mailbox's unique id
     * @returns the shared mailbox's contact informations
     */
    getVCard(uid: string,  __fetchOptions?: RequestOptions): Promise<VCard>;
}

export declare class SharedMailboxClient extends ApiEndPoint implements ISharedMailbox {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    byEmail(email: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SharedMailbox>>;
    byName(login: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SharedMailbox>>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SharedMailbox>>;
    getLight(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<SharedMailbox>>;
    getVCard(uid: string,  __fetchOptions?: RequestOptions): Promise<VCard>;
    getMetadata(): EndPointMetadata;
}
