import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ILdapImport {
    fullSync(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Test LDAP parameters from core service
     * @param allCertificate accept all certificate if true
     */
    testParameters(hostname?: string, protocol?: string, allCertificate?: string, basedn?: string, logindn?: string, password?: string, userfilter?: string, groupfilter?: string,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class LdapImportClient extends ApiEndPoint implements ILdapImport {
    constructor(apiKey: string, base?: string);
    fullSync(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    testParameters(hostname?: string, protocol?: string, allCertificate?: string, basedn?: string, logindn?: string, password?: string, userfilter?: string, groupfilter?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
