
import { JobExitStatus } from "./JobExitStatus"; 
/**
 * Represents a set of searchable job attributes.
 */
export type JobExecutionQuery = {
    /**
     * Identifying a job by his name (example : "LdapImportJob").
     */
    jobId?: string;
    domain?: string;
    /**
     * Execution ID.
     */
    id?: number;
    /**
     * Job exit status.
     */
    statuses?: Array<JobExitStatus>;
    /**
     * To search only active jobs.
     */
    active?: boolean;
    /**
     * Allow to skip the first result(s).
     */
    from?: number;
    /**
     * Maximum size for the results.
     */
    size?: number;
};
