import { 
    DirBaseValue
} from "@bluemind/directory.api";

import { ResourceReservationMode } from "./ResourceReservationMode"; 
/**
 * Resources are used, for example, to create an entity like a vehicle, a
 * meeting room, a video-projector, etc. They can be categorized by type.
 * 
 * Once created, you can invite a resource to a calendar event. It simply means
 * the resource is booked during the time of the event.
 */
export type ResourceDescriptor = DirBaseValue & {
    /**
     * Name your resource
     */
    label?: string;
    /**
     * { @link net.bluemind.resource.api.type.ResourceType } uid or "default" if
     * resource has no type
     */
    typeIdentifier?: string;
    /**
     * Description
     */
    description?: string;
    /**
     * { @link ResourceReservationMode } default reservation mode is
     * {@link ResourceReservationMode#AUTO_ACCEPT_REFUSE}
     */
    reservationMode?: ResourceReservationMode;
    /**
     * Custom properties
     */
    properties?: Array<ResourceDescriptor.PropertyValue>;
};
export namespace ResourceDescriptor {
    export type PropertyValue = {
        propertyId?: string;
        value?: string;
    };

}
