export type Domain = {
    /**
     * A short text associated to your domain name
     */
    label?: string;
    /**
     * Fully qualified domain name
     */
    name?: string;
    /**
     * Description
     */
    description?: string;
    /**
     * Custom properties
     */
    properties?: Record<string, string>;
    /**
     * True, if this is the management domain global.virt
     */
    global?: boolean;
    /**
     * Additional domain names pointing to this domain
     */
    aliases?: Array<string>;
    /**
     * Default alias to use on this domain (must be contained in aliases or equals
     * to name)
     */
    defaultAlias?: string;
};
