import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './DirEntryPathClient.json';

export class DirEntryPathClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/directory/path');
    }
    async getPath(domain, uid, kind,  __fetchOptions = {}) {
        let __path = this.base + '/{domain}/{uid}';
        __path = __path.replace('{domain}', encodeURIComponent(domain));
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (kind != null) {
            __url.searchParams.append("kind", kind);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
