import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific device container UIDs
 */
export interface IDeviceUids {
    /**
     * Returns the default user devices UID
     * @param uid the {@link net.bluemind.user.api.User} UID
     * @returns default user devices UID
     */
    getDefaultUserDevices(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class DeviceUidsClient extends ApiEndPoint implements IDeviceUids {
    constructor(apiKey: string, base?: string);
    getDefaultUserDevices(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
