import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './VEventClient.json';

export class VEventClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/calendars/vevent/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async exportAll( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', '*/*', __fetchOptions);
        return this.__fetchBlob(__url, __options);
    }
    async exportIcs(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async importIcs(ics,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (ics != null) {
            __options.body = ics;
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
