import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './CalendarUidsClient.json';

export class CalendarUidsClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/calendar/uids');
    }
    async getDefaultUserCalendar(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_default_calendar';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getResourceCalendar(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_resource_calendar';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getUserCreatedCalendar(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_other_calendar';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
