import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific calendar container UIDs.
 */
export interface ICalendarUids {
    /**
     * Returns the default user calendar UID
     * @param uid the {@link net.bluemind.user.api.User} UID
     * @returns default user calendar UID
     */
    getDefaultUserCalendar(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Returns the ressource calendar UIDs
     * @param uid unique calendar UID
     * @returns ressource calendar UID
     */
    getResourceCalendar(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Returns the UID of user-created calendars
     * @returns calendar UID
     */
    getUserCreatedCalendar(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class CalendarUidsClient extends ApiEndPoint implements ICalendarUids {
    constructor(apiKey: string, base?: string);
    getDefaultUserCalendar(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getResourceCalendar(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getUserCreatedCalendar(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
