import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './CalendarSettingsClient.json';

export class CalendarSettingsClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, calendarUid , base = '') {
        super(apiKey, base + '/api/calendars/{calendarUid}/_config');
        this.calendarUid = calendarUid;
        this.base = this.base.replace('{calendarUid}', encodeURIComponent(calendarUid));
    }
    async get( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async set(settings,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (settings != null) {
            __options.body = JSON.stringify(settings);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
