import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './CalendarAutocompleteClient.json';

export class CalendarAutocompleteClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/calendar/autocomplete');
    }
    async calendarGroupLookup(groupUid,  __fetchOptions = {}) {
        let __path = this.base + '/_calendarsGroupLookup/{groupUid}';
        __path = __path.replace('{groupUid}', encodeURIComponent(groupUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async calendarLookup(pattern, verb,  __fetchOptions = {}) {
        let __path = this.base + '/_calendarLookup/{pattern}';
        __path = __path.replace('{pattern}', encodeURIComponent(pattern));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (verb != null) {
            __options.body = JSON.stringify(verb);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
