
import { Conversation } from "./Conversation"; 
import { 
    SortDescriptor
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Handle message conversations for a given container (per user or mail-share).
 */
export interface IMailConversation {
    /**
     * Retrieve the conversations of the given folder.
     */
    byFolder(folder?: string, sorted?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Retrieve the conversation having the given Cyrus identifier.
     */
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<Conversation>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<Conversation>>;
}

export declare class MailConversationClient extends ApiEndPoint implements IMailConversation {
    subtreeContainer: string;
    constructor(apiKey: string, subtreeContainer: string, base?: string);
    byFolder(folder?: string, sorted?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<Conversation>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<Conversation>>;
    getMetadata(): EndPointMetadata;
}
