import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './MailConversationActionsClient.json';

export class MailConversationActionsClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, conversationContainer , replicatedMailboxUid , base = '') {
        super(apiKey, base + '/api/mail_conversation/{conversationContainer}/{replicatedMailboxUid}');
        this.conversationContainer = conversationContainer;
        this.base = this.base.replace('{conversationContainer}', encodeURIComponent(conversationContainer));
        this.replicatedMailboxUid = replicatedMailboxUid;
        this.base = this.base.replace('{replicatedMailboxUid}', encodeURIComponent(replicatedMailboxUid));
    }
    async addFlag(flagUpdate,  __fetchOptions = {}) {
        let __path = this.base + '/_addFlag';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (flagUpdate != null) {
            __options.body = JSON.stringify(flagUpdate);
        }
		return this.__fetchContent(__url, __options);
    }
    async copy(targetMailboxUid, conversationUids,  __fetchOptions = {}) {
        let __path = this.base + '/copy/{targetMailboxUid}';
        __path = __path.replace('{targetMailboxUid}', encodeURIComponent(targetMailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (conversationUids != null) {
            __options.body = JSON.stringify(conversationUids);
        }
		return this.__fetchContent(__url, __options);
    }
    async deleteFlag(flagUpdate,  __fetchOptions = {}) {
        let __path = this.base + '/_deleteFlag';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (flagUpdate != null) {
            __options.body = JSON.stringify(flagUpdate);
        }
		return this.__fetchContent(__url, __options);
    }
    async importItems(folderDestinationId, mailboxItems,  __fetchOptions = {}) {
        let __path = this.base + '/importItems/{folderDestinationId}';
        __path = __path.replace('{folderDestinationId}', encodeURIComponent(folderDestinationId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (mailboxItems != null) {
            __options.body = JSON.stringify(mailboxItems);
        }
		return this.__fetchContent(__url, __options);
    }
    async move(targetMailboxUid, conversationUids,  __fetchOptions = {}) {
        let __path = this.base + '/move/{targetMailboxUid}';
        __path = __path.replace('{targetMailboxUid}', encodeURIComponent(targetMailboxUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (conversationUids != null) {
            __options.body = JSON.stringify(conversationUids);
        }
		return this.__fetchContent(__url, __options);
    }
    async multipleDeleteById(conversationUids,  __fetchOptions = {}) {
        let __path = this.base + '/_multipleDelete';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (conversationUids != null) {
            __options.body = JSON.stringify(conversationUids);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
