import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './UserAccessTokenClient.json';

export class UserAccessTokenClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/auth/access_token');
    }
    async authCodeReceived(state, code,  __fetchOptions = {}) {
        let __path = this.base + '/_auth';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (state != null) {
            __url.searchParams.append("state", state);
        }
        if (code != null) {
            __url.searchParams.append("code", code);
        }
		return this.__fetchContent(__url, __options);
    }
    async getTokenInfo(external_system, baseUrl,  __fetchOptions = {}) {
        let __path = this.base + '/_info';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (external_system != null) {
            __url.searchParams.append("external_system", external_system);
        }
        if (baseUrl != null) {
            __url.searchParams.append("baseUrl", baseUrl);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
