
export type Announcement = {
    target?: Announcement.Target;
    kind?: Announcement.Kind;
    message?: string;
    closeable?: boolean;
    data?: Record<string, string>;
    link?: string;
};
export namespace Announcement {
    export type Kind =  "Info" |  "Warn" |  "Error";
    export const Kind : {
        readonly Info: Kind,
        readonly Warn: Kind,
        readonly Error: Kind
    };
    export type Target =  "Admin" |  "User" |  "All";
    export const Target : {
        readonly Admin: Target,
        readonly User: Target,
        readonly All: Target
    };

}
