/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DomainTemplateTagGwtSerDer implements GwtSerDer<net.bluemind.system.api.DomainTemplate.Tag> {

	public DomainTemplateTagGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.DomainTemplate.Tag deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.DomainTemplate.Tag ret = new net.bluemind.system.api.DomainTemplate.Tag();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.DomainTemplate.Tag ret, JSONObject json) {
		JSONValue valueJSON = json.get("value");
		ret.value =  GwtSerDerUtils.STRING.deserialize(valueJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionGwtSerDer().deserialize(descriptionJSON);
		JSONValue multivalJSON = json.get("multival");
		ret.multival =  GwtSerDerUtils.BOOLEAN.deserialize(multivalJSON);
		JSONValue mandatoryJSON = json.get("mandatory");
		ret.mandatory =  GwtSerDerUtils.BOOLEAN.deserialize(mandatoryJSON);
		JSONValue autoAssignJSON = json.get("autoAssign");
		ret.autoAssign =  GwtSerDerUtils.BOOLEAN.deserialize(autoAssignJSON);
	}

	public void deserializeTo(net.bluemind.system.api.DomainTemplate.Tag ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("value")) {
			JSONValue valueJSON = json.get("value");
			ret.value =  GwtSerDerUtils.STRING.deserialize(valueJSON);
		}
		if (!childPropertiesToIgnore.contains("description")) {
			JSONValue descriptionJSON = json.get("description");
			ret.description =  new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionGwtSerDer().deserialize(descriptionJSON);
		}
		if (!childPropertiesToIgnore.contains("multival")) {
			JSONValue multivalJSON = json.get("multival");
			ret.multival =  GwtSerDerUtils.BOOLEAN.deserialize(multivalJSON);
		}
		if (!childPropertiesToIgnore.contains("mandatory")) {
			JSONValue mandatoryJSON = json.get("mandatory");
			ret.mandatory =  GwtSerDerUtils.BOOLEAN.deserialize(mandatoryJSON);
		}
		if (!childPropertiesToIgnore.contains("autoAssign")) {
			JSONValue autoAssignJSON = json.get("autoAssign");
			ret.autoAssign =  GwtSerDerUtils.BOOLEAN.deserialize(autoAssignJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.DomainTemplate.Tag o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.DomainTemplate.Tag o, JSONObject ret) {

		ret.put("value",  GwtSerDerUtils.STRING.serialize( o.value ));
		ret.put("description",  new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionGwtSerDer().serialize( o.description ));
		ret.put("multival",  GwtSerDerUtils.BOOLEAN.serialize( o.multival ));
		ret.put("mandatory",  GwtSerDerUtils.BOOLEAN.serialize( o.mandatory ));
		ret.put("autoAssign",  GwtSerDerUtils.BOOLEAN.serialize( o.autoAssign ));
	}

	public void serializeTo(net.bluemind.system.api.DomainTemplate.Tag o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("value")) {
			ret.put("value",  GwtSerDerUtils.STRING.serialize( o.value ));
		}
		if (!childPropertiesToIgnore.contains("description")) {
			ret.put("description",  new net.bluemind.system.api.gwt.serder.DomainTemplateDescriptionGwtSerDer().serialize( o.description ));
		}
		if (!childPropertiesToIgnore.contains("multival")) {
			ret.put("multival",  GwtSerDerUtils.BOOLEAN.serialize( o.multival ));
		}
		if (!childPropertiesToIgnore.contains("mandatory")) {
			ret.put("mandatory",  GwtSerDerUtils.BOOLEAN.serialize( o.mandatory ));
		}
		if (!childPropertiesToIgnore.contains("autoAssign")) {
			ret.put("autoAssign",  GwtSerDerUtils.BOOLEAN.serialize( o.autoAssign ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}