/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class ExternalSystemEndpointPromise implements net.bluemind.system.api.IExternalSystemPromise {

	private net.bluemind.system.api.IExternalSystemAsync impl;

	public ExternalSystemEndpointPromise(net.bluemind.system.api.IExternalSystemAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.system.api.ExternalSystem> getExternalSystem(String systemIdentifier  ) {
		
		CompletableFuture<net.bluemind.system.api.ExternalSystem> ret = new CompletableFuture<net.bluemind.system.api.ExternalSystem>();
		AsyncHandler<net.bluemind.system.api.ExternalSystem> handler = new AsyncHandler<net.bluemind.system.api.ExternalSystem>() {
			public void success(net.bluemind.system.api.ExternalSystem value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getExternalSystem(systemIdentifier,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.system.api.ExternalSystem>> getExternalSystems() {
		
		CompletableFuture<List<net.bluemind.system.api.ExternalSystem>> ret = new CompletableFuture<List<net.bluemind.system.api.ExternalSystem>>();
		AsyncHandler<List<net.bluemind.system.api.ExternalSystem>> handler = new AsyncHandler<List<net.bluemind.system.api.ExternalSystem>>() {
			public void success(List<net.bluemind.system.api.ExternalSystem> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getExternalSystems( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.system.api.ExternalSystem>> getExternalSystemsByAuthKind(Set<net.bluemind.system.api.ExternalSystem.AuthKind> authKinds  ) {
		
		CompletableFuture<List<net.bluemind.system.api.ExternalSystem>> ret = new CompletableFuture<List<net.bluemind.system.api.ExternalSystem>>();
		AsyncHandler<List<net.bluemind.system.api.ExternalSystem>> handler = new AsyncHandler<List<net.bluemind.system.api.ExternalSystem>>() {
			public void success(List<net.bluemind.system.api.ExternalSystem> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getExternalSystemsByAuthKind(authKinds,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<byte[]> getLogo(String systemIdentifier  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getLogo(systemIdentifier,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.system.api.ConnectionTestStatus> testConnection(String systemIdentifier ,  net.bluemind.user.api.UserAccount account  ) {
		
		CompletableFuture<net.bluemind.system.api.ConnectionTestStatus> ret = new CompletableFuture<net.bluemind.system.api.ConnectionTestStatus>();
		AsyncHandler<net.bluemind.system.api.ConnectionTestStatus> handler = new AsyncHandler<net.bluemind.system.api.ConnectionTestStatus>() {
			public void success(net.bluemind.system.api.ConnectionTestStatus value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.testConnection(systemIdentifier, account,  handler);
		return ret;
	}

}
