/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class CredentialsGwtEndpoint implements net.bluemind.system.api.ICredentialsAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public CredentialsGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/credentials/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public CredentialsGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void addTotpCredential(net.bluemind.system.api.TotpCredential totpCredential, final AsyncHandler<String> handler) {
		String postUri = "/user/totp";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.system.api.gwt.serder.TotpCredentialGwtSerDer().serialize( totpCredential);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<String>(handler) {
			@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getObfuscatedUserCredentials(String userUid, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>> handler) {
		String postUri = "/user/{userUid}";

		postUri = postUri.replace("{userUid}", URL.encodePathSegment(""+userUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>>(handler) {
			@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.system.api.gwt.serder.CredentialGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getSelfObfuscatedCredentials(final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>> handler) {
		String postUri = "/user/_credentials/_self";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>>(handler) {
			@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.system.api.gwt.serder.CredentialGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void removeSelfCredential(String credentialId, final AsyncHandler<Void> handler) {
		String postUri = "/user/_credentials/{credentialId}/_self";

		postUri = postUri.replace("{credentialId}", URL.encodePathSegment(""+credentialId));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void removeUserCredential(String userUid, String credentialId, final AsyncHandler<Void> handler) {
		String postUri = "/user/{userUid}/{credentialId}";

		postUri = postUri.replace("{userUid}", URL.encodePathSegment(""+userUid));
		postUri = postUri.replace("{credentialId}", URL.encodePathSegment(""+credentialId));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void validateTotpCredential(net.bluemind.system.api.TotpCredential totpCredential, final AsyncHandler<Boolean> handler) {
		String postUri = "/user/totp/validate";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.system.api.gwt.serder.TotpCredentialGwtSerDer().serialize( totpCredential);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Boolean>(handler) {
			@Override
			protected Boolean handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.BOOLEAN.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.system.api.ICredentialsPromise promiseApi() {
		return new CredentialsEndpointPromise(this);
	}
}
