/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.resource.api.type.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class ResourceTypesSockJsEndpoint implements net.bluemind.resource.api.type.IResourceTypesAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public ResourceTypesSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/resources/{domainUid}/type";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public ResourceTypesSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void create(String identifier, net.bluemind.resource.api.type.ResourceTypeDescriptor resourceTypeDescriptor, final AsyncHandler<Void> handler) {
		String postUri = "/{identifier}";

		postUri = postUri.replace("{identifier}", URL.encodePathSegment(""+identifier));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.resource.api.type.gwt.serder.ResourceTypeDescriptorGwtSerDer().serialize( resourceTypeDescriptor);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void delete(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void get(String uid, final AsyncHandler<net.bluemind.resource.api.type.ResourceTypeDescriptor> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.resource.api.type.ResourceTypeDescriptor>(handler) {
					@Override
			protected net.bluemind.resource.api.type.ResourceTypeDescriptor handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.resource.api.type.gwt.serder.ResourceTypeDescriptorGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getIcon(String uid, final AsyncHandler<byte[]> handler) {
		String postUri = "/{uid}/icon";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<byte[]>(handler) {
					@Override
			protected byte[] handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ByteArraySerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getTypes(final AsyncHandler<List<net.bluemind.resource.api.type.ResourceType>> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.resource.api.type.ResourceType>>(handler) {
					@Override
			protected List<net.bluemind.resource.api.type.ResourceType> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.resource.api.type.gwt.serder.ResourceTypeGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void setIcon(String uid, byte[] icon, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/icon";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ByteArraySerDer().serialize( icon);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void update(String uid, net.bluemind.resource.api.type.ResourceTypeDescriptor resourceTypeDescriptor, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.resource.api.type.gwt.serder.ResourceTypeDescriptorGwtSerDer().serialize( resourceTypeDescriptor);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.resource.api.type.IResourceTypesPromise promiseApi() {
		return new ResourceTypesEndpointPromise(this);
	}

}
