/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.common.restore;

import java.util.ArrayList;
import java.util.List;

import net.bluemind.dataprotect.api.DPError;
import net.bluemind.dataprotect.api.Restorable;

public class RestoreRestorableItem implements IMonitoredRestoreRestorableItem {

	private final Restorable item;
	protected final List<DPError> errors = new ArrayList<>();

	public RestoreRestorableItem(Restorable item) {
		this.item = item;
	}

	@Override
	public List<DPError> errors() {
		return errors;
	}

	@Override
	public Restorable item() {
		return item;
	}

	@Override
	public String domain() {
		return item.domainUid;
	}

	@Override
	public String entryUid() {
		return item.entryUid;
	}

	@Override
	public String displayName() {
		return item.displayName;
	}

	@Override
	public String liveEntryUid() {
		return item.liveEntryUid();
	}

	@Override
	public void setLiveEntryUid(String uid) {
		item.setLiveEntryUid(uid);
	}

	@Override
	public String startRestoreMsg(String type) {
		return String.format("Starting restore for %s UID: %s from old UID: %s on domain %s", type, liveEntryUid(),
				entryUid(), domain());

	}

	@Override
	public String startExportMsg(String type) {
		return String.format("Starting export for %s UID: %s from old UID: %s on domain %s", type, liveEntryUid(),
				entryUid(), domain());

	}
}
