/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.common.restore;

import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.dataprotect.api.Restorable;

public class MonitoredRestoreRestorableItem extends RestoreRestorableItem {

	private final IServerTaskMonitor monitor;

	public MonitoredRestoreRestorableItem(Restorable item, IServerTaskMonitor monitor) {
		super(item);
		this.monitor = monitor;
	}

	@Override
	public void endTask() {
		if (!errors.isEmpty()) {
			errors.forEach(e -> monitor.error(e.toString()));
			monitorEnd(false, "Error: " + displayName() + " (" + entryUid() + ") restoration failed.", "[KO]");
		} else {
			monitorEnd(true, "Success: " + displayName() + " (" + entryUid() + ") restoration finished.", "[OK]");
		}
	}

	@Override
	public void monitorBegin(double total, String log) {
		monitor.begin(total, log);
	}

	@Override
	public void monitorEnd(boolean success, String log, String result) {
		monitor.end(success, log, result);
	}

	@Override
	public void monitorLog(String format, Object... params) {
		monitor.log(format, params);
	}

	@Override
	public IServerTaskMonitor getMonitor() {
		return monitor;
	}

	@Override
	public IServerTaskMonitor monitorSubWork(double i) {
		return monitor.subWork(i);
	}

}
