/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.common.backup;

import java.io.IOException;
import java.nio.file.Path;

import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.utils.JsonUtils.ValueWriter;
import net.bluemind.dataprotect.api.GenerationIndex;
import net.bluemind.directory.api.DirEntry;

public class RestorableDirEntry<T> {

	public ItemValue<DirEntry> dirEntry;
	public ItemValue<T> item;

	public RestorableDirEntry() {
	}

	public RestorableDirEntry(ItemValue<DirEntry> dirEntry, ItemValue<T> item) {
		this.dirEntry = dirEntry;
		this.item = item;
	}

	public GenerationIndex fromRestorable() {
		return new GenerationIndex(dirEntry.uid, dirEntry.displayName, dirEntry.value.email, dirEntry.value.path,
				dirEntry.value.kind, dirEntry.value.dataLocation);
	}

	public GenerationIndex writeRestorable(ValueWriter writer, Path p) throws IOException {
		JsonReadWrite.write(writer, p, this);
		return fromRestorable();
	}
}
