<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * DirBaseValue.
 */
class DirBaseValue  {

  /*
   * @type String
   */
  public $orgUnitUid;

  /*
   * @type Collection
   */
  public $emails;

  /*
   * @type boolean
   */
  public $hidden;

  /*
   * @type boolean
   */
  public $archived;

  /*
   * @type boolean
   */
  public $system;

  /*
   * @type String
   */
  public $dataLocation;

  /*
   * Constructor
   */
  public function __construct() {
    $this->orgUnitUid = "";
    $this->emails =   new Collection();
    $this->hidden = false;
    $this->archived = false;
    $this->system = false;
    $this->dataLocation = "";
  }

  public function toMap() {
    $data = array(    
        "orgUnitUid" => empty($this->orgUnitUid) ? null : $this->orgUnitUid,    
        "emails" => empty($this->emails) ? null : $this->emails,    
        "hidden" => empty($this->hidden) ? null : $this->hidden,    
        "archived" => empty($this->archived) ? null : $this->archived,    
        "system" => empty($this->system) ? null : $this->system,    
        "dataLocation" => empty($this->dataLocation) ? null : $this->dataLocation);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
