/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2020
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.hornetq.client;

import java.util.Map;
import java.util.function.Supplier;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Suppliers;

import net.bluemind.hornetq.client.MQ.SharedMap;

public class Shared {
	/**
	 * Shared map<String,String> holding system configuration values
	 */
	public static final String MAP_SYSCONF = "system.configuration";

	/**
	 * Shared map<String,String> holding domain settings and properties values
	 */
	public static final String MAP_DOMAIN_SETTINGS = "domain.settings";

	private static final Supplier<SharedMap<String, String>> sysconfSharedMapSupplier = Suppliers
			.memoize(() -> MQ.sharedMap(Shared.MAP_SYSCONF));
	private static final Supplier<SharedMap<String, Map<String, String>>> domainSettingsMapSupplier = Suppliers
			.memoize(() -> MQ.sharedMap(Shared.MAP_DOMAIN_SETTINGS, new TypeReference<Map<String, String>>() {
			}));

	private Shared() {
	}

	public static SharedMap<String, String> mapSysconf() {
		return sysconfSharedMapSupplier.get();
	}

	public static SharedMap<String, Map<String, String>> mapDomainSettings() {
		return domainSettingsMapSupplier.get();
	}
}
