/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.data;

import java.util.Map;

import org.w3c.dom.Element;

import net.bluemind.eas.backend.IApplicationData;
import net.bluemind.eas.session.BackendSession;

public interface IDataDecoder {

	IApplicationData decode(BackendSession bs, Element syncData);

	default IApplicationData decode(BackendSession bs, Element syncData, Map<String, Object> data) {
		return decode(bs, syncData);
	}

}
