/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.eas.backend.importer;

import java.util.Collection;

import net.bluemind.eas.dto.base.CollectionItem;
import net.bluemind.eas.dto.type.ItemDataType;
import net.bluemind.eas.session.BackendSession;

public class ContentImportEntityForDeletion extends ContentImportEntity {

	public Collection<CollectionItem> serverIds;
	public boolean moveToTrash;

	public ContentImportEntityForDeletion(BackendSession backendSession, ItemDataType type) {
		super(backendSession, type);
	}

	public static ContentImportEntityForDeletion create(BackendSession backendSession, ItemDataType type,
			Collection<CollectionItem> serverIds, boolean moveToTrash) {
		ContentImportEntityForDeletion contentEntity = new ContentImportEntityForDeletion(backendSession, type);
		contentEntity.serverIds = serverIds;
		contentEntity.moveToTrash = moveToTrash;
		return contentEntity;
	}

}
