/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2024
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.eas.backend;

import java.util.Date;

public class MailboxVacation {
	public final boolean enabled;
	public final Date start;
	public final Date end;
	public final String text;
	public final String textHtml;
	public final String subject;

	public MailboxVacation(boolean enabled, Date start, Date end, String text, String textHtml, String subject) {
		this.enabled = enabled;
		this.start = start;
		this.end = end;
		this.text = text;
		this.textHtml = textHtml;
		this.subject = subject;
	}

	@Override
	public String toString() {
		return "MailboxVacation [enabled=" + enabled + ", start=" + start + ",  end=" + end + ", text=" + text
				+ ", textHtml=" + textHtml + ", subject=" + subject + "]";
	}
}
