/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Verticle;
import net.bluemind.eas.config.global.GlobalConfig;
import net.bluemind.lib.vertx.IUniqueVerticleFactory;
import net.bluemind.lib.vertx.IVerticleFactory;
import net.bluemind.lib.vertx.VertxPlatform;

public class ConfFileWatcherVerticle extends AbstractVerticle {
	private static final Logger logger = LoggerFactory.getLogger(ConfFileWatcherVerticle.class);

	public static class Factory implements IVerticleFactory, IUniqueVerticleFactory {

		@Override
		public boolean isWorker() {
			return true;
		}

		@Override
		public Verticle newInstance() {
			return new ConfFileWatcherVerticle();
		}

	}

	@Override
	public void start() {
		GlobalConfig globalConfig = GlobalConfig.get();
		try {
			globalConfig.loadConfig();
		} catch (IOException e) {
			logger.error("EAS GlobalConfig cannot be updated because : {}", e.getMessage());
		}

		VertxPlatform.executeBlockingPeriodic(20000, tid -> {
			try {
				if (globalConfig.changes()) {
					globalConfig.configUpdate();
				}
			} catch (IOException e) {
				logger.error("EAS GlobalConfig cannot be updated because : {}", e.getMessage());
			}
		});
	}

}
