import FDBFactory from "fake-indexeddb/lib/FDBFactory";
import { vi } from "vitest";

import SMimePkiDB from "../pki/SMimePkiDB";

vi.mock("@bluemind/session", () => ({
    default: {
        userId: "my-user-id",
        addEventListener: vi.fn()
    }
}));

describe("SMimePkiDB", () => {
    beforeEach(async () => {
        global.indexedDB = new FDBFactory();
        await SMimePkiDB.clearMyCertsAndKeys();
    });

    describe("clearPKI", () => {
        test("reset all data from pki", async () => {
            await SMimePkiDB.setPrivateKeys(["heya"]);
            const privKey = await SMimePkiDB.getPrivateKeys();
            expect(privKey).toStrictEqual(["heya"]);

            await SMimePkiDB.clearMyCertsAndKeys();
            const noPrivKeys = await SMimePkiDB.getPrivateKeys();
            expect(noPrivKeys).toBeUndefined();
        });
    });
    describe("getPrivateKeys", () => {
        test("return undefined if there is no key", async () => {
            const privKey = await SMimePkiDB.getPrivateKeys();
            expect(privKey).toBe(undefined);
        });
        test("get and set key content", async () => {
            await SMimePkiDB.setPrivateKeys(["heya"]);
            const privKey = await SMimePkiDB.getPrivateKeys();
            expect(privKey).toStrictEqual(["heya"]);
        });
    });
    describe("setPrivateKeys", () => {
        test("overwrite private key if already set", async () => {
            await SMimePkiDB.setPrivateKeys("plop");
            await SMimePkiDB.setPrivateKeys("anotherPlop");
            const privKey = await SMimePkiDB.getPrivateKeys();
            expect(privKey).toBe("anotherPlop");
        });
        test("do nothing if new private key content is empty", async () => {
            const privKey = await SMimePkiDB.getPrivateKeys();
            expect(privKey).toBe(undefined);
            await SMimePkiDB.setPrivateKeys("");
            expect(privKey).toBe(undefined);
        });
    });
    describe("setCertificates", () => {
        test("set certificate content", async () => {
            await SMimePkiDB.setCertificates("ok");
            const cert = await SMimePkiDB.getCertificates();
            expect(cert).toBe("ok");
        });
        test("overwrite certificate if already set", async () => {
            await SMimePkiDB.setCertificates("plop");
            await SMimePkiDB.setCertificates("anotherPlop");
            const privKey = await SMimePkiDB.getCertificates();
            expect(privKey).toBe("anotherPlop");
        });
        test("do nothing if new certificate content is empty", async () => {
            await SMimePkiDB.setCertificates();
            let cert = await SMimePkiDB.setCertificates("");
            expect(cert).toBe(undefined);
            cert = await SMimePkiDB.setCertificates(null);
            expect(cert).toBe(undefined);
            cert = await SMimePkiDB.setCertificates();
            expect(cert).toBe(undefined);
        });
    });
    describe("getCertificates", () => {
        test("get certificate content", async () => {
            await SMimePkiDB.setCertificates("plop");
            const cert = await SMimePkiDB.getCertificates();
            expect(cert).toBe("plop");
        });
        test("return undefined if there is no certificate", async () => {
            const cert = await SMimePkiDB.getCertificates();
            expect(cert).toBe(undefined);
        });
    });
});
