import { MessageBody } from "@bluemind/backend.mail.api";
import { EmlParser } from "@bluemind/mime";

import { getCacheKey, getGuid } from "./cache/SMimePartCache";

export default async function saveParts(content: string, folderUid: string, imapUid: number) {
    const parser = await new EmlParser().parse(content);
    const parts = parser.getParts();

    const savePartsPromises = [];
    for (const p of parts) {
        const partContent = parser.getPartContent(p.address!);
        const promise = savePart(folderUid, imapUid, p, partContent);
        savePartsPromises.push(promise);
    }
    await Promise.all(savePartsPromises);
    return {
        preview: parser.body.preview,
        structure: parser.body.structure
    };
}

async function savePart(
    folderUid: string,
    imapUid: number,
    part: MessageBody.Part,
    content: ArrayBuffer | undefined
): Promise<void> {
    const cache: Cache = await caches.open("smime-part-cache");
    const { address } = part;
    const guid = await getGuid(folderUid, imapUid);
    if (address && guid) {
        const key = await getCacheKey(address, guid, folderUid);
        cache.put(new Request(key), new Response(content));
    }
}
