/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CalendarViewGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.CalendarView> {

	public CalendarViewGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.CalendarView deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.CalendarView ret = new net.bluemind.calendar.api.CalendarView();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.CalendarView ret, JSONObject json) {
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.calendar.api.gwt.serder.CalendarViewCalendarViewTypeGwtSerDer().deserialize(typeJSON);
		JSONValue isDefaultJSON = json.get("isDefault");
		ret.isDefault =  GwtSerDerUtils.BOOLEAN.deserialize(isDefaultJSON);
		JSONValue calendarsJSON = json.get("calendars");
		ret.calendars =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(calendarsJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.CalendarView ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("label")) {
			JSONValue labelJSON = json.get("label");
			ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.calendar.api.gwt.serder.CalendarViewCalendarViewTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("isDefault")) {
			JSONValue isDefaultJSON = json.get("isDefault");
			ret.isDefault =  GwtSerDerUtils.BOOLEAN.deserialize(isDefaultJSON);
		}
		if (!childPropertiesToIgnore.contains("calendars")) {
			JSONValue calendarsJSON = json.get("calendars");
			ret.calendars =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(calendarsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.CalendarView o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.CalendarView o, JSONObject ret) {

		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("type",  new net.bluemind.calendar.api.gwt.serder.CalendarViewCalendarViewTypeGwtSerDer().serialize( o.type ));
		ret.put("isDefault",  GwtSerDerUtils.BOOLEAN.serialize( o.isDefault ));
		ret.put("calendars",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.calendars ));
	}

	public void serializeTo(net.bluemind.calendar.api.CalendarView o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("label")) {
			ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.calendar.api.gwt.serder.CalendarViewCalendarViewTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("isDefault")) {
			ret.put("isDefault",  GwtSerDerUtils.BOOLEAN.serialize( o.isDefault ));
		}
		if (!childPropertiesToIgnore.contains("calendars")) {
			ret.put("calendars",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.calendars ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}