/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CalendarLookupResponseGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.CalendarLookupResponse> {

	public CalendarLookupResponseGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.CalendarLookupResponse deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.CalendarLookupResponse ret = new net.bluemind.calendar.api.CalendarLookupResponse();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.CalendarLookupResponse ret, JSONObject json) {
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.calendar.api.gwt.serder.CalendarLookupResponseTypeGwtSerDer().deserialize(typeJSON);
		JSONValue emailJSON = json.get("email");
		ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		JSONValue memberCountJSON = json.get("memberCount");
		ret.memberCount =  GwtSerDerUtils.INT.deserialize(memberCountJSON);
		JSONValue ownerUidJSON = json.get("ownerUid");
		ret.ownerUid =  GwtSerDerUtils.STRING.deserialize(ownerUidJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.CalendarLookupResponse ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("uid")) {
			JSONValue uidJSON = json.get("uid");
			ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.calendar.api.gwt.serder.CalendarLookupResponseTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("email")) {
			JSONValue emailJSON = json.get("email");
			ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		}
		if (!childPropertiesToIgnore.contains("memberCount")) {
			JSONValue memberCountJSON = json.get("memberCount");
			ret.memberCount =  GwtSerDerUtils.INT.deserialize(memberCountJSON);
		}
		if (!childPropertiesToIgnore.contains("ownerUid")) {
			JSONValue ownerUidJSON = json.get("ownerUid");
			ret.ownerUid =  GwtSerDerUtils.STRING.deserialize(ownerUidJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.CalendarLookupResponse o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.CalendarLookupResponse o, JSONObject ret) {

		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("type",  new net.bluemind.calendar.api.gwt.serder.CalendarLookupResponseTypeGwtSerDer().serialize( o.type ));
		ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		ret.put("memberCount",  GwtSerDerUtils.INT.serialize( o.memberCount ));
		ret.put("ownerUid",  GwtSerDerUtils.STRING.serialize( o.ownerUid ));
	}

	public void serializeTo(net.bluemind.calendar.api.CalendarLookupResponse o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("uid")) {
			ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.calendar.api.gwt.serder.CalendarLookupResponseTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("email")) {
			ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		}
		if (!childPropertiesToIgnore.contains("memberCount")) {
			ret.put("memberCount",  GwtSerDerUtils.INT.serialize( o.memberCount ));
		}
		if (!childPropertiesToIgnore.contains("ownerUid")) {
			ret.put("ownerUid",  GwtSerDerUtils.STRING.serialize( o.ownerUid ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}