/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.actions.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleActionGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction> {

	public MailFilterRuleActionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		return delegateDeserialization(json);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction ret, JSONObject json) {
		JSONValue nameJSON = json.get("name");
		ret.name =  new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionNameGwtSerDer().deserialize(nameJSON);
		JSONValue clientPropertiesJSON = json.get("clientProperties");
		ret.clientProperties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(clientPropertiesJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionNameGwtSerDer().deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("clientProperties")) {
			JSONValue clientPropertiesJSON = json.get("clientProperties");
			ret.clientProperties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(clientPropertiesJSON);
		}
	}

	public net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction delegateDeserialization(JSONObject json) {
		JSONValue discriminatorValue = json.get("name");
		String discriminator = GwtSerDerUtils.STRING.deserialize(discriminatorValue);
		switch (discriminator) {
		case "PRIORITIZE":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionPrioritizeGwtSerDer().deserialize(json);
		case "CATEGORIZE":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionCategorizeGwtSerDer().deserialize(json);
		case "MARK_AS_IMPORTANT":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionMarkAsImportantGwtSerDer().deserialize(json);
		case "UNCATEGORIZE":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionUncategorizeGwtSerDer().deserialize(json);
		case "COPY":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionCopyGwtSerDer().deserialize(json);
		case "MARK_AS_READ":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionMarkAsReadGwtSerDer().deserialize(json);
		case "SET_FLAGS":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionSetFlagsGwtSerDer().deserialize(json);
		case "REPLY":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionReplyGwtSerDer().deserialize(json);
		case "UNFOLLOW":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionUnfollowGwtSerDer().deserialize(json);
		case "ADD_HEADER":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionAddHeadersGwtSerDer().deserialize(json);
		case "MARK_AS_DELETED":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionMarkAsDeletedGwtSerDer().deserialize(json);
		case "DISCARD":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionDiscardGwtSerDer().deserialize(json);
		case "MOVE":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionMoveGwtSerDer().deserialize(json);
		case "TRANSFER":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionTransferGwtSerDer().deserialize(json);
		case "DEFERRED_ACTION":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionDeferredActionGwtSerDer().deserialize(json);
		case "REMOVE_HEADERS":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionRemoveHeadersGwtSerDer().deserialize(json);
		case "CUSTOM":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionCustomGwtSerDer().deserialize(json);
		case "REDIRECT":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionRedirectGwtSerDer().deserialize(json);
		}
		return null;
	}

	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction o) {
		if (o == null) {
			return null;
		}

		return delegateSerialization(o);
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction o, JSONObject ret) {

		ret.put("name",  new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionNameGwtSerDer().serialize( o.name ));
		ret.put("clientProperties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.clientProperties ));
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionNameGwtSerDer().serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("clientProperties")) {
			ret.put("clientProperties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.clientProperties ));
		}
	}

	public JSONValue delegateSerialization(net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction o) {
		String discriminator = o.name.toString();
		switch (discriminator) {
		case "PRIORITIZE":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionPrioritizeGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionPrioritize)o);
		case "CATEGORIZE":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionCategorizeGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize)o);
		case "MARK_AS_IMPORTANT":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionMarkAsImportantGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionMarkAsImportant)o);
		case "UNCATEGORIZE":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionUncategorizeGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionUncategorize)o);
		case "COPY":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionCopyGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy)o);
		case "MARK_AS_READ":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionMarkAsReadGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionMarkAsRead)o);
		case "SET_FLAGS":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionSetFlagsGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionSetFlags)o);
		case "REPLY":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionReplyGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionReply)o);
		case "UNFOLLOW":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionUnfollowGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionUnfollow)o);
		case "ADD_HEADER":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionAddHeadersGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionAddHeaders)o);
		case "MARK_AS_DELETED":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionMarkAsDeletedGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionMarkAsDeleted)o);
		case "DISCARD":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionDiscardGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionDiscard)o);
		case "MOVE":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionMoveGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionMove)o);
		case "TRANSFER":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionTransferGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionTransfer)o);
		case "DEFERRED_ACTION":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionDeferredActionGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionDeferredAction)o);
		case "REMOVE_HEADERS":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionRemoveHeadersGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionRemoveHeaders)o);
		case "CUSTOM":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionCustomGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCustom)o);
		case "REDIRECT":
			return new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionRedirectGwtSerDer().serialize((net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionRedirect)o);
		}
		return null;
	}

	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}