/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.rules.actions.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailFilterRuleActionName extends JavaScriptObject {

	protected JsMailFilterRuleActionName() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsMailFilterRuleActionName ADD_HEADER()
	/*-{
		return "ADD_HEADER";
	}-*/;

	public static final native JsMailFilterRuleActionName CATEGORIZE()
	/*-{
		return "CATEGORIZE";
	}-*/;

	public static final native JsMailFilterRuleActionName COPY()
	/*-{
		return "COPY";
	}-*/;

	public static final native JsMailFilterRuleActionName CUSTOM()
	/*-{
		return "CUSTOM";
	}-*/;

	public static final native JsMailFilterRuleActionName DEFERRED_ACTION()
	/*-{
		return "DEFERRED_ACTION";
	}-*/;

	public static final native JsMailFilterRuleActionName DISCARD()
	/*-{
		return "DISCARD";
	}-*/;

	public static final native JsMailFilterRuleActionName MARK_AS_DELETED()
	/*-{
		return "MARK_AS_DELETED";
	}-*/;

	public static final native JsMailFilterRuleActionName MARK_AS_IMPORTANT()
	/*-{
		return "MARK_AS_IMPORTANT";
	}-*/;

	public static final native JsMailFilterRuleActionName MARK_AS_READ()
	/*-{
		return "MARK_AS_READ";
	}-*/;

	public static final native JsMailFilterRuleActionName MOVE()
	/*-{
		return "MOVE";
	}-*/;

	public static final native JsMailFilterRuleActionName PRIORITIZE()
	/*-{
		return "PRIORITIZE";
	}-*/;

	public static final native JsMailFilterRuleActionName REDIRECT()
	/*-{
		return "REDIRECT";
	}-*/;

	public static final native JsMailFilterRuleActionName REMOVE_HEADERS()
	/*-{
		return "REMOVE_HEADERS";
	}-*/;

	public static final native JsMailFilterRuleActionName REPLY()
	/*-{
		return "REPLY";
	}-*/;

	public static final native JsMailFilterRuleActionName SET_FLAGS()
	/*-{
		return "SET_FLAGS";
	}-*/;

	public static final native JsMailFilterRuleActionName TRANSFER()
	/*-{
		return "TRANSFER";
	}-*/;

	public static final native JsMailFilterRuleActionName UNCATEGORIZE()
	/*-{
		return "UNCATEGORIZE";
	}-*/;

	public static final native JsMailFilterRuleActionName UNFOLLOW()
	/*-{
		return "UNFOLLOW";
	}-*/;

	public static final JsMailFilterRuleActionName create(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionName value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case ADD_HEADER:
				return ADD_HEADER();
			case CATEGORIZE:
				return CATEGORIZE();
			case COPY:
				return COPY();
			case CUSTOM:
				return CUSTOM();
			case DEFERRED_ACTION:
				return DEFERRED_ACTION();
			case DISCARD:
				return DISCARD();
			case MARK_AS_DELETED:
				return MARK_AS_DELETED();
			case MARK_AS_IMPORTANT:
				return MARK_AS_IMPORTANT();
			case MARK_AS_READ:
				return MARK_AS_READ();
			case MOVE:
				return MOVE();
			case PRIORITIZE:
				return PRIORITIZE();
			case REDIRECT:
				return REDIRECT();
			case REMOVE_HEADERS:
				return REMOVE_HEADERS();
			case REPLY:
				return REPLY();
			case SET_FLAGS:
				return SET_FLAGS();
			case TRANSFER:
				return TRANSFER();
			case UNCATEGORIZE:
				return UNCATEGORIZE();
			case UNFOLLOW:
				return UNFOLLOW();
			default:
				return null;
			}
		}
	}
}