/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailboxGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.Mailbox> {

	public MailboxGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.Mailbox deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.Mailbox ret = new net.bluemind.mailbox.api.Mailbox();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.Mailbox ret, JSONObject json) {
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue systemJSON = json.get("system");
		ret.system =  GwtSerDerUtils.BOOLEAN.deserialize(systemJSON);
		JSONValue hiddenJSON = json.get("hidden");
		ret.hidden =  GwtSerDerUtils.BOOLEAN.deserialize(hiddenJSON);
		JSONValue archivedJSON = json.get("archived");
		ret.archived =  GwtSerDerUtils.BOOLEAN.deserialize(archivedJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.mailbox.api.gwt.serder.MailboxTypeGwtSerDer().deserialize(typeJSON);
		JSONValue routingJSON = json.get("routing");
		ret.routing =  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().deserialize(routingJSON);
		JSONValue emailsJSON = json.get("emails");
		ret.emails =  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).deserialize(emailsJSON);
		JSONValue dataLocationJSON = json.get("dataLocation");
		ret.dataLocation =  GwtSerDerUtils.STRING.deserialize(dataLocationJSON);
		JSONValue quotaJSON = json.get("quota");
		ret.quota =  GwtSerDerUtils.INT.deserialize(quotaJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.Mailbox ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("system")) {
			JSONValue systemJSON = json.get("system");
			ret.system =  GwtSerDerUtils.BOOLEAN.deserialize(systemJSON);
		}
		if (!childPropertiesToIgnore.contains("hidden")) {
			JSONValue hiddenJSON = json.get("hidden");
			ret.hidden =  GwtSerDerUtils.BOOLEAN.deserialize(hiddenJSON);
		}
		if (!childPropertiesToIgnore.contains("archived")) {
			JSONValue archivedJSON = json.get("archived");
			ret.archived =  GwtSerDerUtils.BOOLEAN.deserialize(archivedJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.mailbox.api.gwt.serder.MailboxTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("routing")) {
			JSONValue routingJSON = json.get("routing");
			ret.routing =  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().deserialize(routingJSON);
		}
		if (!childPropertiesToIgnore.contains("emails")) {
			JSONValue emailsJSON = json.get("emails");
			ret.emails =  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).deserialize(emailsJSON);
		}
		if (!childPropertiesToIgnore.contains("dataLocation")) {
			JSONValue dataLocationJSON = json.get("dataLocation");
			ret.dataLocation =  GwtSerDerUtils.STRING.deserialize(dataLocationJSON);
		}
		if (!childPropertiesToIgnore.contains("quota")) {
			JSONValue quotaJSON = json.get("quota");
			ret.quota =  GwtSerDerUtils.INT.deserialize(quotaJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.Mailbox o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.Mailbox o, JSONObject ret) {

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("system",  GwtSerDerUtils.BOOLEAN.serialize( o.system ));
		ret.put("hidden",  GwtSerDerUtils.BOOLEAN.serialize( o.hidden ));
		ret.put("archived",  GwtSerDerUtils.BOOLEAN.serialize( o.archived ));
		ret.put("type",  new net.bluemind.mailbox.api.gwt.serder.MailboxTypeGwtSerDer().serialize( o.type ));
		ret.put("routing",  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().serialize( o.routing ));
		ret.put("emails",  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).serialize( o.emails ));
		ret.put("dataLocation",  GwtSerDerUtils.STRING.serialize( o.dataLocation ));
		ret.put("quota",  GwtSerDerUtils.INT.serialize( o.quota ));
	}

	public void serializeTo(net.bluemind.mailbox.api.Mailbox o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("system")) {
			ret.put("system",  GwtSerDerUtils.BOOLEAN.serialize( o.system ));
		}
		if (!childPropertiesToIgnore.contains("hidden")) {
			ret.put("hidden",  GwtSerDerUtils.BOOLEAN.serialize( o.hidden ));
		}
		if (!childPropertiesToIgnore.contains("archived")) {
			ret.put("archived",  GwtSerDerUtils.BOOLEAN.serialize( o.archived ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.mailbox.api.gwt.serder.MailboxTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("routing")) {
			ret.put("routing",  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().serialize( o.routing ));
		}
		if (!childPropertiesToIgnore.contains("emails")) {
			ret.put("emails",  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).serialize( o.emails ));
		}
		if (!childPropertiesToIgnore.contains("dataLocation")) {
			ret.put("dataLocation",  GwtSerDerUtils.STRING.serialize( o.dataLocation ));
		}
		if (!childPropertiesToIgnore.contains("quota")) {
			ret.put("quota",  GwtSerDerUtils.INT.serialize( o.quota ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}