/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailbox extends JavaScriptObject {

	protected JsMailbox() {}

	public final native String getName()
	/*-{
	return this["name"];
	}-*/;

	public final native void setName(String name)
	/*-{
       this["name"] = name;
	}-*/;

	public final native boolean getSystem()
	/*-{
	return this["system"];
	}-*/;

	public final native void setSystem(boolean system)
	/*-{
       this["system"] = system;
	}-*/;

	public final native boolean getHidden()
	/*-{
	return this["hidden"];
	}-*/;

	public final native void setHidden(boolean hidden)
	/*-{
       this["hidden"] = hidden;
	}-*/;

	public final native boolean getArchived()
	/*-{
	return this["archived"];
	}-*/;

	public final native void setArchived(boolean archived)
	/*-{
       this["archived"] = archived;
	}-*/;

	public final native net.bluemind.mailbox.api.gwt.js.JsMailboxType getType()
	/*-{
	return this["type"];
	}-*/;

	public final native void setType(net.bluemind.mailbox.api.gwt.js.JsMailboxType type)
	/*-{
       this["type"] = type;
	}-*/;

	public final native net.bluemind.mailbox.api.gwt.js.JsMailboxRouting getRouting()
	/*-{
	return this["routing"];
	}-*/;

	public final native void setRouting(net.bluemind.mailbox.api.gwt.js.JsMailboxRouting routing)
	/*-{
       this["routing"] = routing;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.core.api.gwt.js.JsEmail> getEmails()
	/*-{
	return this["emails"];
	}-*/;

	public final native void setEmails(com.google.gwt.core.client.JsArray<net.bluemind.core.api.gwt.js.JsEmail> emails)
	/*-{
       this["emails"] = emails;
	}-*/;

	public final native String getDataLocation()
	/*-{
	return this["dataLocation"];
	}-*/;

	public final native void setDataLocation(String dataLocation)
	/*-{
       this["dataLocation"] = dataLocation;
	}-*/;

	public final native Integer getQuota()
	/*-{
	return ( this["quota"] != null) ? @java.lang.Integer::new(I)(this["quota"]) : null;
	}-*/;

	public final native void setQuota(Integer quota)
	/*-{
       this["quota"] =  ( quota != null) ? quota.@java.lang.Integer::intValue()() : null;
	}-*/;

	public static native  JsMailbox create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}