/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailshare.service.internal;

import java.util.List;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.container.service.internal.ItemValueAuditLogService;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.directory.service.AbstractDirServiceFactory;
import net.bluemind.directory.service.DirEntryAndValue;
import net.bluemind.domain.api.Domain;
import net.bluemind.eclipse.common.RunnableExtensionLoader;
import net.bluemind.mailshare.api.IInternalMailshare;
import net.bluemind.mailshare.api.Mailshare;
import net.bluemind.mailshare.hook.IMailshareHook;

public class InternalMailshareServiceFactory extends AbstractDirServiceFactory<IInternalMailshare>
		implements ServerSideServiceProvider.IServerSideServiceFactory<IInternalMailshare> {

	private static List<IMailshareHook> getHooks() {
		RunnableExtensionLoader<IMailshareHook> loader = new RunnableExtensionLoader<>();
		return loader.loadExtensions("net.bluemind.mailshare.hook", "mailsharehook", "hook", "impl");
	}

	@Override
	public Class<IInternalMailshare> factoryClass() {
		return IInternalMailshare.class;
	}

	@Override
	protected IInternalMailshare instanceImpl(BmContext context, ItemValue<Domain> domainValue, Container container)
			throws ServerFault {
		BaseContainerDescriptor descriptor = BaseContainerDescriptor.create(container.uid, container.name,
				container.owner, container.type, container.domainUid, container.defaultContainer);
		descriptor.internalId = container.id;
		AuditLogDirEntryMailshareMapper mapper = new AuditLogDirEntryMailshareMapper();
		ItemValueAuditLogService<DirEntryAndValue<Mailshare>> logService = new ItemValueAuditLogService<>(context,
				descriptor, mapper);
		return new MailshareService(context, container, domainValue, getHooks(), logService);
	}

}
