/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.keycloak.utils.sessions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;

public class BackchannelLogoutToken {
	private static final Logger logger = LoggerFactory.getLogger(BackchannelLogoutToken.class);

	private final DecodedJWT logoutToken;

	private BackchannelLogoutToken(DecodedJWT logoutToken) {
		this.logoutToken = logoutToken;
	}

	public static BackchannelLogoutToken fromString(String logoutTokenAsString) {
		try {
			return new BackchannelLogoutToken(JWT.decode(logoutTokenAsString));
		} catch (JWTDecodeException jde) {
			if (logger.isDebugEnabled()) {
				logger.debug("Unable to decode jwt: {}", logoutTokenAsString, jde);
			}
		}

		return null;
	}

	public String getSid() {
		Claim jwtSid = logoutToken.getClaim("sid");
		if (jwtSid.isMissing() || jwtSid.isNull()) {
			if (logger.isDebugEnabled()) {
				logger.debug("Missing or invalid SID claim: {}", jwtSid);
			}

			return null;
		}

		return jwtSid.asString();
	}
}
