/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
WebAppDataClient._rpcClient;

/**
 * URL
 */
WebAppDataClient._baseUrl;

/**
 * @type {string} containerUid
 * @private
 */
WebAppDataClient.prototype._containerUid;

/**
 * @constructor
 */ 
function WebAppDataClient(base, sid , containerUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/webappdata/{containerUid}';
  
  this._containerUid = containerUid;
  this._baseUrl = this._baseUrl.replace('{containerUid}',containerUid);
};

WebAppDataClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
WebAppDataClient.prototype.allUids = function() {
  let url = this._baseUrl + "/_alluids";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.changeset = function( since  ) {
  let url = this._baseUrl + "/_changeset";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.changesetById = function( since  ) {
  let url = this._baseUrl + "/_changesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.create = function( uid ,  arg1  ) {
  let url = this._baseUrl + "/uid/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/uid/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.deleteAll = function() {
  let url = this._baseUrl + "/_deleteAll";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.filteredChangesetById = function( since ,  arg1  ) {
  let url = this._baseUrl + "/_filteredChangesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.getByKey = function( key  ) {
  let url = this._baseUrl + "/key/{key}";

  url = url.replace("{key}", key);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/uid/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.getCompleteById = function( id  ) {
  let url = this._baseUrl + "/{id}/completeById";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.getVersion = function() {
  let url = this._baseUrl + "/_version";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.itemChangelog = function( uid ,  arg1  ) {
  let url = this._baseUrl + "/{uid}/_itemchangelog";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.multipleGet = function( arg0  ) {
  let url = this._baseUrl + "/uid/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.multipleGetById = function( arg0  ) {
  let url = this._baseUrl + "/_mgetById";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
WebAppDataClient.prototype.update = function( uid ,  arg1  ) {
  let url = this._baseUrl + "/uid/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

WebAppDataClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
