/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
JobClient._rpcClient;

/**
 * URL
 */
JobClient._baseUrl;

/**
 * @constructor
 */ 
function JobClient(base, sid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/scheduledjobs';
  
};

JobClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
JobClient.prototype.cancel = function( jobId ,  domainName  ) {
  let url = this._baseUrl + "/_cancel/{jobId}";

  url = url.replace("{jobId}", jobId);

  url += "?domainName=" + encodeURIComponent(domainName);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
JobClient.prototype.deleteExecution = function( jobExecutionId  ) {
  let url = this._baseUrl + "/_deleteExecution";


  url += "?jobExecutionId=" + encodeURIComponent(jobExecutionId);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
JobClient.prototype.deleteExecutions = function( executions  ) {
  let url = this._baseUrl + "/_deleteExecutions";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  body = executions;
  return this._execute(cmd, body);
};

/*
 *
 */
JobClient.prototype.getJobFromId = function( jobId  ) {
  let url = this._baseUrl + "/_job/{jobId}";

  url = url.replace("{jobId}", jobId);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
JobClient.prototype.getLogs = function( jobExecution ,  offset  ) {
  let url = this._baseUrl + "/_logs";


  url += "?offset=" + encodeURIComponent(offset);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = jobExecution;
  return this._execute(cmd, body);
};

/*
 *
 */
JobClient.prototype.searchExecution = function( query  ) {
  let url = this._baseUrl + "/_searchExecution";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
JobClient.prototype.searchJob = function( query  ) {
  let url = this._baseUrl + "/_searchJob";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
JobClient.prototype.start = function( jobId ,  domainName  ) {
  let url = this._baseUrl + "/_start/{jobId}";

  url = url.replace("{jobId}", jobId);

  url += "?domainName=" + encodeURIComponent(domainName);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
JobClient.prototype.update = function( job  ) {
  let url = this._baseUrl + "/_updateJob";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = job;
  return this._execute(cmd, body);
};

JobClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
