/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
InternalCredentialsClient._rpcClient;

/**
 * URL
 */
InternalCredentialsClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
InternalCredentialsClient.prototype._domainUid;

/**
 * @constructor
 */ 
function InternalCredentialsClient(base, sid , domainUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/credentials/{domainUid}';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
};

InternalCredentialsClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
InternalCredentialsClient.prototype.addTotpCredential = function( totpCredential  ) {
  let url = this._baseUrl + "/user/totp";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = totpCredential;
  return this._execute(cmd, body);
};

/*
 *
 */
InternalCredentialsClient.prototype.addUserCredential = function( userUid ,  credential  ) {
  let url = this._baseUrl + "/user/{userUid}";

  url = url.replace("{userUid}", userUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = credential;
  return this._execute(cmd, body);
};

/*
 *
 */
InternalCredentialsClient.prototype.addUserCredentials = function( userUid ,  credentials  ) {
  let url = this._baseUrl + "/user/{userUid}/_credentials";

  url = url.replace("{userUid}", userUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = credentials;
  return this._execute(cmd, body);
};

/*
 *
 */
InternalCredentialsClient.prototype.getDomainCredentialById = function( credentialId  ) {
  let url = this._baseUrl + "/{credentialId}";

  url = url.replace("{credentialId}", credentialId);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InternalCredentialsClient.prototype.getObfuscatedUserCredentials = function( userUid  ) {
  let url = this._baseUrl + "/user/{userUid}";

  url = url.replace("{userUid}", userUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InternalCredentialsClient.prototype.getSelfObfuscatedCredentials = function() {
  let url = this._baseUrl + "/user/_credentials/_self";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InternalCredentialsClient.prototype.getUserCredentials = function( userUid  ) {
  let url = this._baseUrl + "/user/{userUid}/plain";

  url = url.replace("{userUid}", userUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InternalCredentialsClient.prototype.removeSelfCredential = function( credentialId  ) {
  let url = this._baseUrl + "/user/_credentials/{credentialId}/_self";

  url = url.replace("{credentialId}", credentialId);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InternalCredentialsClient.prototype.removeUserCredential = function( userUid ,  credentialId  ) {
  let url = this._baseUrl + "/user/{userUid}/{credentialId}";

  url = url.replace("{userUid}", userUid);
  url = url.replace("{credentialId}", credentialId);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InternalCredentialsClient.prototype.validateTotpCredential = function( totpCredential  ) {
  let url = this._baseUrl + "/user/totp/validate";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = totpCredential;
  return this._execute(cmd, body);
};

InternalCredentialsClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
