/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
DirEntryMaintenanceClient._rpcClient;

/**
 * URL
 */
DirEntryMaintenanceClient._baseUrl;

/**
 * @type {string} domain
 * @private
 */
DirEntryMaintenanceClient.prototype._domain;

/**
 * @type {string} entryUid
 * @private
 */
DirEntryMaintenanceClient.prototype._entryUid;

/**
 * @constructor
 */ 
function DirEntryMaintenanceClient(base, sid , domain , entryUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/directory/{domain}/{entryUid}/mgmt';
  
  this._domain = domain;
  this._baseUrl = this._baseUrl.replace('{domain}',domain);
  this._entryUid = entryUid;
  this._baseUrl = this._baseUrl.replace('{entryUid}',entryUid);
};

DirEntryMaintenanceClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
DirEntryMaintenanceClient.prototype.getAvailableOperations = function() {
  let url = this._baseUrl + "/_maintenance";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
DirEntryMaintenanceClient.prototype.repair = function( config  ) {
  let url = this._baseUrl + "/_maintenance/repair";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = config;
  return this._execute(cmd, body);
};

DirEntryMaintenanceClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
