/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
ContainersClient._rpcClient;

/**
 * URL
 */
ContainersClient._baseUrl;

/**
 * @constructor
 */ 
function ContainersClient(base, sid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/containers/_manage';
  
};

ContainersClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
ContainersClient.prototype.all = function( query  ) {
  let url = this._baseUrl + "/_list";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.allForUser = function( domainUid ,  userUid ,  query  ) {
  let url = this._baseUrl + "/_listforuser";


  url += "?domainUid=" + encodeURIComponent(domainUid);
  url += "&userUid=" + encodeURIComponent(userUid);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.allLight = function( query  ) {
  let url = this._baseUrl + "/_listLight";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.create = function( uid ,  descriptor  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = descriptor;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.exists = function( containerUid  ) {
  let url = this._baseUrl + "/_exists";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = containerUid;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.get = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.getAccessControlLists = function( containerIds  ) {
  let url = this._baseUrl + "/_macl";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = containerIds;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.getContainers = function( containerIds  ) {
  let url = this._baseUrl + "/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = containerIds;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.getContainersLight = function( containerIds  ) {
  let url = this._baseUrl + "/_mgetLight";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = containerIds;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.getForUser = function( domainUid ,  userUid ,  uid  ) {
  let url = this._baseUrl + "/_forUser";


  url += "?domainUid=" + encodeURIComponent(domainUid);
  url += "&userUid=" + encodeURIComponent(userUid);
  url += "&uid=" + encodeURIComponent(uid);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.getIfPresent = function( uid  ) {
  let url = this._baseUrl + "/_ifPresent/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.getLight = function( uid  ) {
  let url = this._baseUrl + "/_light/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.getLightIfPresent = function( uid  ) {
  let url = this._baseUrl + "/_ifPresentLight/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.setAccessControlList = function( uid ,  entries  ) {
  let url = this._baseUrl + "/{uid}/_acl";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = entries;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainersClient.prototype.update = function( uid ,  descriptor  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = descriptor;
  return this._execute(cmd, body);
};

ContainersClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
