/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.webappdata.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class WebAppDataEndpointPromise implements net.bluemind.webappdata.api.IWebAppDataPromise {

	private net.bluemind.webappdata.api.IWebAppDataAsync impl;

	public WebAppDataEndpointPromise(net.bluemind.webappdata.api.IWebAppDataAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<String>> allUids() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allUids( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> changeset(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changeset(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> changesetById(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changesetById(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> create(String uid ,  net.bluemind.webappdata.api.WebAppData arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteAll() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteAll( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(Long since ,  net.bluemind.core.container.model.ItemFlagFilter arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.filteredChangesetById(since, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.webappdata.api.WebAppData> getByKey(String key  ) {
		
		CompletableFuture<net.bluemind.webappdata.api.WebAppData> ret = new CompletableFuture<net.bluemind.webappdata.api.WebAppData>();
		AsyncHandler<net.bluemind.webappdata.api.WebAppData> handler = new AsyncHandler<net.bluemind.webappdata.api.WebAppData>() {
			public void success(net.bluemind.webappdata.api.WebAppData value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getByKey(key,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> getCompleteById(long id  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getCompleteById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Long> getVersion() {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVersion( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(String uid ,  Long arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ItemChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ItemChangelog>() {
			public void success(net.bluemind.core.container.model.ItemChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.itemChangelog(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>> multipleGet(List<String> arg0  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGet(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>> multipleGetById(List<Long> arg0  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGetById(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> update(String uid ,  net.bluemind.webappdata.api.WebAppData arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, arg1,  handler);
		return ret;
	}

}
