package net.bluemind.core.container.hooks.aclchangednotification;

import java.util.List;

import net.bluemind.core.container.hooks.IAclHook;
import net.bluemind.core.container.model.ContainerDescriptor;
import net.bluemind.core.container.model.acl.AccessControlEntry;
import net.bluemind.core.container.model.acl.AclDiff;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.LocalJsonObject;
import net.bluemind.lib.vertx.VertxPlatform;
import net.bluemind.system.api.SystemState;
import net.bluemind.system.state.StateContext;

public class AclChangedNotificationHook implements IAclHook {

	@Override
	public void onAclChanged(BmContext context, ContainerDescriptor container, List<AccessControlEntry> previous,
			List<AccessControlEntry> current) {
		if (StateContext.getState() == SystemState.CORE_STATE_CLONING) {
			return;
		}

		previous = AccessControlEntry.compact(previous);
		current = AccessControlEntry.compact(current);

		List<AclDiff> diff = AclDiff.prepareAclDiff(context.getSecurityContext().getSubject(), previous, current);

		if (!diff.isEmpty()) {
			AclChangedMsg aclChangeMsg = new AclChangedMsg(context.getSecurityContext().getSubject(),
					context.getSecurityContext().getContainerUid(), container.uid, container.name, container.type,
					container.ownerDisplayname, diff,
					context.getSecurityContext().getSubject().equals(container.owner));
			VertxPlatform.eventBus().publish(
					AclChangedNotificationVerticle.ACL_CHANGED_NOTIFICATION_COLLECT_BUS_ADDRESS,
					new LocalJsonObject<>(aclChangeMsg));
		}
	}

}
