package net.bluemind.core.container.hooks.aclchangednotification;

import java.util.List;
import java.util.stream.Collectors;

import net.bluemind.core.container.model.acl.AclDiff;

public record AclChangedMsg(String sourceUserId, String domainUid, String containerUid, String containerName,
		String containerType, String containerOwnerDisplayname, List<AclDiff> changes, boolean isItsOwnContainer) {

	@Override
	public String toString() {
		return "AclChangedMsg [domainUid=" + domainUid + ", sourceUserId=" + sourceUserId + ", containerUid="
				+ containerUid + ", containerName=" + containerName + ", containerType=" + containerType
				+ ", containerOwnerDisplayname=" + containerOwnerDisplayname + ", isItsOwnContainer="
				+ isItsOwnContainer + ", acls=(" + aclToString() + ")]";
	}

	private String aclToString() {
		return changes.stream().map(ace -> ace.toString()).collect(Collectors.joining(", "));
	}
}
