/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.repository.sequences;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.eclipse.common.RunnableExtensionLoader;

public class SequenceStores {

	private static final Logger logger = LoggerFactory.getLogger(SequenceStores.class);
	private static final List<ISequenceStore> stores = registeredStores();

	private static List<ISequenceStore> registeredStores() {
		RunnableExtensionLoader<ISequenceStore> rel = new RunnableExtensionLoader<>();
		return rel.loadExtensions("net.bluemind.repository.provider", "sequence", "store", "impl");
	}

	private static final ISequenceStore defaultStore = defaultStore();

	private static final ISequenceStore defaultStore() {
		if (stores.isEmpty()) {
			logger.warn("DUMMY sequence store selected ({} impls available).", stores.size());
			return new DummySequenceStore();
		} else {
			var sel = stores.getFirst();
			logger.info("Sequence store {} selected.", sel);
			return sel;
		}
	}

	public static ISequenceStore getDefault() {
		return defaultStore;
	}

	private SequenceStores() {

	}

}
