/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.smime.cacerts.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RevocationResultGwtSerDer implements GwtSerDer<net.bluemind.smime.cacerts.api.RevocationResult> {

	public RevocationResultGwtSerDer( ) {
	}

	@Override
	public net.bluemind.smime.cacerts.api.RevocationResult deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.smime.cacerts.api.RevocationResult ret = new net.bluemind.smime.cacerts.api.RevocationResult();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.smime.cacerts.api.RevocationResult ret, JSONObject json) {
		JSONValue revocationJSON = json.get("revocation");
		ret.revocation =  new net.bluemind.smime.cacerts.api.gwt.serder.SmimeRevocationGwtSerDer().deserialize(revocationJSON);
		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.smime.cacerts.api.gwt.serder.RevocationResultRevocationStatusGwtSerDer().deserialize(statusJSON);
	}

	public void deserializeTo(net.bluemind.smime.cacerts.api.RevocationResult ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("revocation")) {
			JSONValue revocationJSON = json.get("revocation");
			ret.revocation =  new net.bluemind.smime.cacerts.api.gwt.serder.SmimeRevocationGwtSerDer().deserialize(revocationJSON);
		}
		if (!childPropertiesToIgnore.contains("status")) {
			JSONValue statusJSON = json.get("status");
			ret.status =  new net.bluemind.smime.cacerts.api.gwt.serder.RevocationResultRevocationStatusGwtSerDer().deserialize(statusJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.smime.cacerts.api.RevocationResult o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.smime.cacerts.api.RevocationResult o, JSONObject ret) {

		ret.put("revocation",  new net.bluemind.smime.cacerts.api.gwt.serder.SmimeRevocationGwtSerDer().serialize( o.revocation ));
		ret.put("status",  new net.bluemind.smime.cacerts.api.gwt.serder.RevocationResultRevocationStatusGwtSerDer().serialize( o.status ));
	}

	public void serializeTo(net.bluemind.smime.cacerts.api.RevocationResult o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("revocation")) {
			ret.put("revocation",  new net.bluemind.smime.cacerts.api.gwt.serder.SmimeRevocationGwtSerDer().serialize( o.revocation ));
		}
		if (!childPropertiesToIgnore.contains("status")) {
			ret.put("status",  new net.bluemind.smime.cacerts.api.gwt.serder.RevocationResultRevocationStatusGwtSerDer().serialize( o.status ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}